<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/tngweb/header.php');

$fee = 0;
checkServiceStatus($udata, 'aadhar_enrollment_status');

$captcha = fetchAadharCaptcha();

if ($_SERVER['REQUEST_METHOD']==='POST' && !empty($_POST['eid'])) {

    $eid        = trim($_POST['eid']);
    $captchaTxt = trim($_POST['captcha']);
    $captchaSID = $_POST['captchaTxnId'];
    $user       = $udata['phone'];

    // API CALL
    $resdata = enrollment_status_verification_api_run([
        'eid'        => $eid,
        'captcha'    => $captchaTxt,
        'captchaSID' => $captchaSID
    ]);

    $sampleCode = $resdata['sampleCode'] ?? '';
    $errorMsg   = $resdata['error'] ?? '';

    // ❌ FAILED
    if (!empty($errorMsg)) {
        echo "<script>
            Swal.fire('Failed','".addslashes($errorMsg)."','error');
        </script>";
        exit;
    }

    // ✅ SUCCESS
    if ($sampleCode === "200") {

        // BASE64 JSON SAVE
        $base64Json = base64_encode(
            json_encode($resdata, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES)
        );

        mysqli_query($tng_conn,"
            INSERT INTO all_pdf_records
            (service_name,name,username,number,pdf,date)
            VALUES(
                'AADHAAR_EID_STATUS',
                '".mysqli_real_escape_string($tng_conn,$resdata['resMessageCode'] ?? 'EID Status')."',
                '$user',
                '".mysqli_real_escape_string($tng_conn,$eid)."',
                '".mysqli_real_escape_string($tng_conn,$base64Json)."',
                NOW()
            )
        ");

        echo "<script>
            Swal.fire({
                icon:'success',
                title:'Status Found',
                text:'{$resdata['resMessage']}',
                timer:2500,
                showConfirmButton:false
            }).then(()=>window.location='all_history.php');
        </script>";
        exit;
    }
}
?>

<!-- ================= LUXURY UI ================= -->
<style>
body{
  background:linear-gradient(135deg,#eef2ff,#f9fafb);
}
.lux-card{
  background:rgba(255,255,255,.92);
  backdrop-filter:blur(18px);
  border-radius:22px;
  box-shadow:0 25px 50px rgba(0,0,0,.12);
  padding:30px;
}
.title{
  font-weight:700;
  color:#4338ca;
}
.back-btn{
  font-weight:600;
  text-decoration:none;
}
</style>

<div class="page-wrapper">
<div class="page-content">
<div class="container">

<div class="row justify-content-center align-items-center" style="min-height:80vh;">
<div class="col-lg-5 col-md-7 col-sm-10">

<div class="lux-card">

<div class="mb-3">
  <a href="javascript:history.back()" class="back-btn text-primary">
    <i class="bi bi-arrow-left-circle"></i> Back
  </a>
</div>

<h4 class="title text-center mb-2">
  🆔 Aadhaar Enrollment Status
</h4>
<p class="text-muted text-center mb-4">
  Check Aadhaar Enrollment Status using EID
</p>

<form method="post" id="eidForm">

<div class="mb-3">
  <label class="fw-semibold">Enrollment ID (EID)</label>
  <input type="text" name="eid" class="form-control form-control-lg"
         placeholder="Enter 28-digit EID with timestamp" required>
</div>

<div class="mb-3">
  <label class="fw-semibold">Captcha</label><br>
  <img src="<?= $captcha['captcha']; ?>"
       style="border:1px solid #ccc;border-radius:6px;margin-bottom:6px;">
  <input type="hidden" name="captchaTxnId"
         value="<?= $captcha['captchaTxnId']; ?>">
  <input type="text" name="captcha"
         class="form-control mt-2" placeholder="Enter captcha" required>
</div>

<div class="row align-items-center mt-4">
  <div class="col-6">
    <input class="form-control fw-bold text-success"
           value="Fee ₹ <?= $fee ?>" readonly>
  </div>
  <div class="col-6 text-end">
    <button type="submit" id="submitBtn"
            class="btn btn-primary px-4 rounded-pill">
      <i class="fa fa-search"></i> Check Status
    </button>
  </div>
</div>

</form>

</div>
</div>
</div>

</div>
</div>
</div>

<!-- ================= CONFIRM + DOUBLE SUBMIT ================= -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
let locked=false;
document.getElementById('eidForm').addEventListener('submit',function(e){
  e.preventDefault();
  if(locked) return;

  Swal.fire({
    title:'Confirm?',
    text:'Proceed to check enrollment status',
    icon:'question',
    showCancelButton:true,
    confirmButtonText:'Yes',
    cancelButtonText:'Cancel'
  }).then(r=>{
    if(r.isConfirmed){
      locked=true;
      document.getElementById('submitBtn').disabled=true;
      this.submit();
    }
  });
});
</script>

<?php include('../template/tngweb/footer.php'); ?>
