<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/tngweb/header.php');

$baseFee = $udata['tng_pan_details'];
checkServiceStatus($udata,'tng_pan_details_status');

$charges = [
    'server_1' => $baseFee,
    'server_2' => $baseFee + 5
];

if ($_SERVER['REQUEST_METHOD']==='POST'
    && !empty($_POST['pan'])
    && !empty($_POST['pantype'])
) {

    $pan   = strtoupper(trim($_POST['pan']));
    $type  = $_POST['pantype'];
    $fee   = $charges[$type] ?? $baseFee;

    $user   = $udata['phone'];
    $wallet = $udata['balance'];

    /* ❌ LOW BALANCE */
    if ($wallet < $fee) {
        echo "<script>
            Swal.fire('Wallet Low','Please recharge wallet','error')
            .then(()=>window.location='wallet.php');
        </script>";
        exit;
    }

    /* API CALL */
    $resdata = pan_verification_api_run([
        'pan'     => $pan,
        'pantype' => $type
    ]);

    $sampleCode = $resdata['sampleCode'] ?? '';
    $errorMsg   = $resdata['error'] ?? 'PAN details not found';

    /* ❌ FAILED */
    if ((string)$sampleCode !== "200") {
        echo "<script>
            Swal.fire('Failed','".addslashes($errorMsg)."','error');
        </script>";
        exit;
    }

    /* ✅ SUCCESS FLOW */

    // Debit wallet
    mysqli_query(
        $tng_conn,
        "UPDATE users SET balance=balance-$fee WHERE phone='$user'"
    );

    // Commission
    addCommission(
        $tng_conn,
        $user,
        $fee,
        $udata['parent'] ?? null,
        'PAN TO PAN DETAILS'
    );

    // Wallet history
    mysqli_query(
        $tng_conn,
        "INSERT INTO wallethistory
        (userid,amount,balance,purpose,status,type)
        VALUES(
          '$user',
          '$fee',
          '".($wallet-$fee)."',
          'PAN TO PAN DETAILS',
          '1',
          'Debit'
        )"
    );

    /* BASE64 JSON SAVE */
    $base64Json = base64_encode(
        json_encode($resdata,JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES)
    );

    mysqli_query(
        $tng_conn,
        "INSERT INTO all_pdf_records
        (service_name,name,username,number,pdf,date)
        VALUES(
          'PAN_TO_PAN_DETAILS',
          '".$resdata['fullname']."',
          '$user',
          '$pan',
          '".mysqli_real_escape_string($tng_conn,$base64Json)."',
          NOW()
        )"
    );

    /* SUCCESS ALERT + REDIRECT */
    echo "<script>
        Swal.fire({
            icon:'success',
            title:'PAN VERIFIED',
            text:'PAN details fetched & saved successfully',
            timer:2200,
            showConfirmButton:false
        }).then(()=>window.location='all_history.php');
    </script>";
    exit;
}
?>

<!-- ================= LUXURY UI ================= -->
<style>
body{
  background:linear-gradient(135deg,#eef2ff,#fdf2f8);
}
.glass{
  background:#fff;
  border-radius:22px;
  box-shadow:0 25px 55px rgba(0,0,0,.14);
  padding:36px;
}
.title{
  font-weight:700;
  color:#312e81;
}
.back-btn{
  text-decoration:none;
  font-weight:600;
}
</style>

<div class="page-wrapper">
<div class="page-content">
<div class="container">

<div class="row justify-content-center align-items-center" style="min-height:80vh;"> 
<div class="col-lg-5 col-md-7 col-sm-10">

<div class="glass">

<div class="mb-3">
    <a href="javascript:history.back()" class="back-btn text-primary">
        <i class="bi bi-arrow-left-circle"></i> Back
    </a>
</div>

<h4 class="title text-center mb-2">
🪪 PAN → PAN DETAILS
</h4>

<p class="text-center text-muted mb-4">
Verify PAN details using secure government sources
</p>

<form method="post" id="panForm">

<div class="mb-3">
    <label class="fw-semibold">PAN Number</label>
    <input type="text"
           name="pan"
           maxlength="10"
           class="form-control form-control-lg text-uppercase"
           placeholder="ABCDE1234F"
           required>
</div>

<div class="mb-3">
    <label class="fw-semibold">Select Server</label>
    <select name="pantype"
            id="serverType"
            class="form-control form-control-lg"
            required>
        <option value="">Select Server</option>
        <option value="server_1">Server 1</option>
        <option value="server_2">Server 2</option>
    </select>
</div>

<div class="row mt-4 align-items-center">
    <div class="col-6">
        <input id="feeBox"
               class="form-control fw-bold text-success"
               value="Fee ₹ -"
               readonly>
    </div>
    <div class="col-6 text-end">
        <button type="submit"
                id="submitBtn"
                class="btn btn-primary px-4 rounded-pill">
            <i class="fa fa-search"></i> Verify PAN
        </button>
    </div>
</div>

</form>

</div>
</div>
</div>

</div>
</div>
</div>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
const charges = <?= json_encode($charges); ?>;
document.getElementById('serverType').addEventListener('change',function(){
    document.getElementById('feeBox').value =
        'Fee ₹ ' + (charges[this.value] ?? '-');
});

/* 🔒 DOUBLE SUBMIT LOCK + CONFIRM */
let lock=false;
document.getElementById('panForm').addEventListener('submit',function(e){
    e.preventDefault();
    if(lock) return;

    Swal.fire({
        title:'Confirm Verification?',
        text:'Proceed with PAN verification?',
        icon:'question',
        showCancelButton:true,
        confirmButtonText:'Yes',
        cancelButtonText:'Cancel'
    }).then(r=>{
        if(r.isConfirmed){
            lock=true;
            document.getElementById('submitBtn').disabled=true;
            this.submit();
        }
    });
});
</script>

<?php include('../template/tngweb/footer.php'); ?>
