<?php
session_start();
ob_start();
include('../includes/config.php');
ob_clean();

mysqli_set_charset($tng_conn, "utf8mb4");

if (isset($_POST['download_pdf']) && isset($_SESSION['aadhaar_pdf'])) {

    $pdfBinary = $_SESSION['aadhaar_pdf'];
    $filename  = $_SESSION['aadhaar_pdf_name'] ?? 'aadhaar.pdf';

    // ❌ direct view nahi
    header("Content-Type: application/pdf");
    header("Content-Disposition: attachment; filename=\"$filename\"");
    header("Content-Length: " . strlen($pdfBinary));
    header("Cache-Control: no-store, no-cache, must-revalidate");
    header("Pragma: no-cache");

    echo $pdfBinary;
    exit;
}

if (!isset($_GET['aadharautoid'], $_GET['type'])) {
    die("Missing parameters");
}

$aadharautoid = intval(base64_decode($_GET['aadharautoid']));
$type         = base64_decode($_GET['type']);

$q = mysqli_query(
    $tng_conn,
    "SELECT * FROM aadharauto WHERE aadharautoid='$aadharautoid' LIMIT 1"
);
if (!$q || mysqli_num_rows($q) === 0) {
    die("No record found");
}
$data = mysqli_fetch_assoc($q);

$postData = [
    "data_base64" => base64_encode(json_encode($data, JSON_UNESCAPED_UNICODE)),
    "type"        => $type
];

$ch = curl_init($aadharpdf);
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST           => true,
    CURLOPT_POSTFIELDS     => $postData
]);
$response  = curl_exec($ch);
$curlError = curl_error($ch);
curl_close($ch);

if ($curlError) {
    die("Curl Error: $curlError");
}

$resData = json_decode($response, true);
if (empty($resData['pdf'])) {
    die("Invalid API response");
}

$pdfBase64 = preg_replace('/^data:application\/pdf;base64,/', '', $resData['pdf']);
$pdfBinary = base64_decode($pdfBase64);

if ($pdfBinary === false || strlen($pdfBinary) < 100) {
    die("PDF decode failed");
}

$filename = preg_replace(
    '/[^a-zA-Z0-9_\-]/',
    '_',
    ($resData['file_name'] ?? "Aadhaar_$aadharautoid")
) . ".pdf";


$_SESSION['aadhaar_pdf']      = $pdfBinary;
$_SESSION['aadhaar_pdf_name'] = $filename;
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Aadhaar PDF Ready</title>

<style>
body{
    margin:0;
    height:100vh;
    display:flex;
    align-items:center;
    justify-content:center;
    background:radial-gradient(circle at center,#1e3c72,#2a5298);
    font-family:Segoe UI,Roboto,sans-serif;
}
.card{
    background:#fff;
    padding:40px;
    border-radius:18px;
    text-align:center;
    box-shadow:0 20px 50px rgba(0,0,0,.35);
    animation:shine 1.8s infinite alternate;
    width:360px;
}
@keyframes shine{
    from{box-shadow:0 15px 35px rgba(0,0,0,.3);}
    to{box-shadow:0 25px 60px rgba(0,0,0,.5);}
}
h2{
    color:#1e3c72;
    margin-bottom:8px;
}
p{
    color:#555;
    margin-bottom:25px;
}
.btn{
    display:block;
    width:100%;
    padding:14px;
    font-size:17px;
    border-radius:50px;
    border:none;
    cursor:pointer;
    margin-bottom:12px;
    transition:.3s;
}
.download{
    background:linear-gradient(45deg,#ff9800,#ff5722);
    color:#fff;
    box-shadow:0 8px 20px rgba(0,0,0,.3);
}
.download:hover{
    transform:scale(1.05);
    box-shadow:0 14px 30px rgba(0,0,0,.45);
}
.back{
    background:#f1f1f1;
    color:#333;
}
.back:hover{
    background:#e0e0e0;
}
</style>
</head>

<body>

<div class="card">
    <h2>✅ PDF Ready</h2>
    <p>Your Aadhaar PDF is generated successfully</p>

    <!-- DOWNLOAD BUTTON -->
    <form method="POST">
        <button class="btn download" type="submit" name="download_pdf">
            ⬇ Download PDF
        </button>
    </form>

    <!-- BACK BUTTON -->
    <button class="btn back" onclick="window.history.back();">
        🔙 Go Back
    </button>
</div>

</body>
</html>
