<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/tngweb/header.php');

$fee = $udata['udyam_number_to_msme_udyam_fee'];
checkServiceStatus($udata,'udyam_number_to_msme_udyam_fee_status');

if ($_SERVER['REQUEST_METHOD']==='POST' && !empty($_POST['udyam_number'])) {

    $udyam = strtoupper(trim($_POST['udyam_number']));
    $user  = $udata['phone'];
    $wallet= $udata['balance'];

    /* ❌ LOW BALANCE */
    if ($wallet < $fee) {
        echo "<script>
            Swal.fire('Wallet Low','Please recharge wallet','error')
            .then(()=>window.location='wallet.php');
        </script>";
        exit;
    }

    /* API CALL */
    $resdata = msme_udyam_to_pdf_verification_api_run([
        'udyam_number' => $udyam
    ]);

    $sampleCode = $resdata['sampleCode'] ?? '';
    $errorMsg   = $resdata['error'] ?? 'Details not found';

    /* ❌ ERROR */
    if ((string)$sampleCode !== "200") {
        echo "<script>
            Swal.fire('Failed','".addslashes($errorMsg)."','error');
        </script>";
        exit;
    }

    /* ✅ SUCCESS FLOW */

    // Debit wallet
    mysqli_query(
        $tng_conn,
        "UPDATE users SET balance=balance-$fee WHERE phone='$user'"
    );

    // Commission
    addCommission(
        $tng_conn,
        $user,
        $fee,
        $udata['parent'] ?? null,
        'UDYAM TO MSME'
    );

    // Wallet history
    mysqli_query(
        $tng_conn,
        "INSERT INTO wallethistory
        (userid,amount,balance,purpose,status,type)
        VALUES(
          '$user',
          '$fee',
          '".($wallet-$fee)."',
          'UDYAM TO MSME',
          '1',
          'Debit'
        )"
    );

    /* BASE64 JSON SAVE */
    $base64Json = base64_encode(
        json_encode($resdata,JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES)
    );

    mysqli_query(
        $tng_conn,
        "INSERT INTO all_pdf_records
        (service_name,name,username,number,pdf,date)
        VALUES(
          'UDYAM_TO_MSME',
          '".$resdata['pan']."',
          '$user',
          '$udyam',
          '".mysqli_real_escape_string($tng_conn,$base64Json)."',
          NOW()
        )"
    );

    /* SUCCESS ALERT + REDIRECT */
    echo "<script>
        Swal.fire({
            icon:'success',
            title:'UDYAM FOUND',
            text:'MSME Udyam details saved successfully',
            timer:2200,
            showConfirmButton:false
        }).then(()=>window.location='all_history.php');
    </script>";
    exit;
}
?>

<!-- ================= LUXURY UI ================= -->
<style>
body{
  background:linear-gradient(135deg,#eef2ff,#fdf2f8);
}
.glass{
  background:#fff;
  border-radius:22px;
  box-shadow:0 25px 55px rgba(0,0,0,.14);
  padding:36px;
}
.back-btn{
  font-weight:600;
  text-decoration:none;
}
.title{
  font-weight:700;
  color:#312e81;
}
</style>

<div class="page-wrapper">
<div class="page-content">
<div class="container">

<div class="row justify-content-center align-items-center" style="min-height:80vh;">
<div class="col-lg-5 col-md-7 col-sm-10">

<div class="glass">

<div class="mb-3">
    <a href="javascript:history.back()" class="back-btn text-primary">
        <i class="bi bi-arrow-left-circle"></i> Back
    </a>
</div>

<h4 class="title text-center mb-2">
🏭 Udyam → MSME Verification
</h4>

<p class="text-center text-muted mb-4">
Fetch MSME Udyam details using Udyam Number
</p>

<form method="post" id="udyamForm">

<div class="mb-3">
    <label class="fw-semibold">Udyam Number</label>
    <input type="text"
           name="udyam_number"
           maxlength="25"
           class="form-control form-control-lg"
           placeholder="Enter Udyam Number"
           required>
</div>

<div class="row mt-4 align-items-center">
    <div class="col-6">
        <input class="form-control fw-bold text-success"
               value="Fee ₹ <?= $fee ?>" readonly>
    </div>
    <div class="col-6 text-end">
        <button type="submit"
                id="submitBtn"
                class="btn btn-primary px-4 rounded-pill">
            <i class="fa fa-search"></i> Fetch Details
        </button>
    </div>
</div>

</form>

</div>
</div>
</div>

</div>
</div>
</div>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
let lock=false;
document.getElementById('udyamForm').addEventListener('submit',function(e){
    e.preventDefault();
    if(lock) return;

    Swal.fire({
        title:'Confirm Request?',
        text:'Proceed with Udyam MSME verification?',
        icon:'question',
        showCancelButton:true,
        confirmButtonText:'Yes',
        cancelButtonText:'Cancel'
    }).then(r=>{
        if(r.isConfirmed){
            lock=true;
            document.getElementById('submitBtn').disabled=true;
            this.submit();
        }
    });
});
</script>

<?php include('../template/tngweb/footer.php'); ?>
