<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/tngweb/header.php');

$fee = $udata['rto_find_fee'];
checkServiceStatus($udata,'rto_find_fee_status');

if ($_SERVER['REQUEST_METHOD']==='POST' && !empty($_POST['rtoCode'])) {

    $rtoCode = strtoupper(trim($_POST['rtoCode']));
    $user    = $udata['phone'];
    $wallet  = $udata['balance'];


    if ($wallet < $fee) {
        echo "<script>
            Swal.fire('Wallet Low','Please recharge wallet','error')
            .then(()=>window.location='wallet.php');
        </script>";
        exit;
    }


    $resdata = rto_verification_run([
        'rtoCode' => $rtoCode
    ]);

    $sampleCode = $resdata['sampleCode'] ?? '';
    $errorMsg   = $resdata['error'] ?? 'RTO details not found';


    if ((string)$sampleCode !== "200") {
        echo "<script>
            Swal.fire('Failed','".addslashes($errorMsg)."','error');
        </script>";
        exit;
    }


    mysqli_query(
        $tng_conn,
        "UPDATE users SET balance=balance-$fee WHERE phone='$user'"
    );

    addCommission(
        $tng_conn,
        $user,
        $fee,
        $udata['parent'] ?? null,
        'RTO CODE FIND'
    );


    mysqli_query(
        $tng_conn,
        "INSERT INTO wallethistory
        (userid,amount,balance,purpose,status,type)
        VALUES(
            '$user',
            '$fee',
            '".($wallet-$fee)."',
            'RTO CODE FIND',
            '1',
            'Debit'
        )"
    );


    $base64Json = base64_encode(
        json_encode($resdata,JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES)
    );

    mysqli_query(
        $tng_conn,
        "INSERT INTO all_pdf_records
        (service_name,name,username,number,pdf,date)
        VALUES(
            'RTO_CODE_FIND',
            '".mysqli_real_escape_string($tng_conn,$resdata['rto'] ?? 'RTO')."',
            '$user',
            '$rtoCode',
            '".mysqli_real_escape_string($tng_conn,$base64Json)."',
            NOW()
        )"
    );


    echo "<script>
        Swal.fire({
            icon:'success',
            title:'SUCCESS',
            text:'RTO details saved successfully',
            timer:2200,
            showConfirmButton:false
        }).then(()=>window.location='all_history.php');
    </script>";
    exit;
}
?>

<!-- ================= LUXURY UI ================= -->
<style>
body{
  background:linear-gradient(135deg,#eef2ff,#fdf2f8);
}
.glass{
  background:#fff;
  border-radius:22px;
  box-shadow:0 25px 55px rgba(0,0,0,.15);
  padding:36px;
}
.title{
  font-weight:700;
  color:#7c2d12;
}
</style>

<div class="page-wrapper">
<div class="page-content">
<div class="container">

<div class="row justify-content-center align-items-center" style="min-height:80vh;">
<div class="col-lg-5 col-md-7 col-sm-10">

<div class="glass">

<div class="mb-3">
    <a href="javascript:history.back()" class="fw-bold text-primary">
        <i class="bi bi-arrow-left-circle"></i> Back
    </a>
</div>

<h4 class="title text-center mb-2">
🚗 RTO Code Finder
</h4>

<p class="text-center text-muted mb-4">
Find RTO details using RTO code (All India)
</p>

<form method="post" id="rtoForm">

<div class="mb-3">
    <label class="fw-semibold">RTO Code</label>
    <input type="text"
           name="rtoCode"
           class="form-control form-control-lg"
           placeholder="Eg: MH12, DL01"
           required>
</div>

<div class="row mt-4 align-items-center">
    <div class="col-6">
        <input class="form-control fw-bold text-success"
               value="Fee ₹ <?= $fee ?>" readonly>
    </div>
    <div class="col-6 text-end">
        <button type="submit"
                id="submitBtn"
                class="btn btn-success px-4 rounded-pill">
            <i class="fa fa-search"></i> Search
        </button>
    </div>
</div>

</form>

</div>
</div>
</div>

</div>
</div>
</div>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
let lock=false;
document.getElementById('rtoForm').addEventListener('submit',function(e){
    e.preventDefault();
    if(lock) return;

    Swal.fire({
        title:'Confirm Request?',
        text:'Proceed with RTO code verification?',
        icon:'question',
        showCancelButton:true,
        confirmButtonText:'Yes',
        cancelButtonText:'Cancel'
    }).then(r=>{
        if(r.isConfirmed){
            lock=true;
            document.getElementById('submitBtn').disabled=true;
            this.submit();
        }
    });
});
</script>

<?php include('../template/tngweb/footer.php'); ?>
