<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/tngweb/header.php');

$today = date('Y-m-d');
$from_date = $_GET['from_date'] ?? '';
$to_date   = $_GET['to_date'] ?? '';

if (!empty($from_date) && !empty($to_date)) {
    $query = "SELECT * FROM wallethistory 
              WHERE DATE(date) BETWEEN '".mysqli_real_escape_string($tng_conn,$from_date)."'
              AND '".mysqli_real_escape_string($tng_conn,$to_date)."'";
} else {
    $query = "SELECT * FROM wallethistory WHERE DATE(date)='$today'";
}

if ($udata['type'] !== 'admin') {
    $query .= " AND userid='".mysqli_real_escape_string($tng_conn,$udata['phone'])."'";
}

$query .= " ORDER BY date DESC";
$res = mysqli_query($tng_conn,$query);
?>

<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.5.0/css/responsive.bootstrap5.min.css">

<div class="page-wrapper">
<div class="page-content">

<div class="card luxury-card shadow-lg border-0">
<div class="card-body">

<div class="d-flex justify-content-between align-items-center mb-4">
  <a href="javascript:history.back()" class="btn btn-outline-primary rounded-pill px-4">
    <i class="fa fa-arrow-left me-2"></i> Go Back
  </a>
  <h4 class="fw-bold text-primary mb-0">💰 Wallet History</h4>
</div>

<!-- FILTER -->
<form method="GET" class="row g-3 mb-4">
  <div class="col-md-3">
    <label class="fw-semibold">From Date</label>
    <input type="date" name="from_date" value="<?= htmlspecialchars($from_date) ?>" class="form-control">
  </div>
  <div class="col-md-3">
    <label class="fw-semibold">To Date</label>
    <input type="date" name="to_date" value="<?= htmlspecialchars($to_date) ?>" class="form-control">
  </div>
  <div class="col-md-6 d-flex align-items-end gap-2">
    <button class="btn btn-primary rounded-pill px-4">
      <i class="fa fa-search"></i> Search
    </button>
    <a href="?" class="btn btn-outline-secondary rounded-pill px-4">
      <i class="fa fa-refresh"></i> Reset
    </a>
  </div>
</form>

<div class="table-responsive">
<table id="walletTable" class="table table-hover align-middle text-center w-100">
<thead class="luxury-thead">
<tr>
  <th>#</th>
  <th>Amount</th>
  <th>Balance</th>
  <th>Purpose</th>
  <th>Type</th>
  <th>User ID</th>
  <th>Date</th>
</tr>
</thead>
<tbody>

<?php
$x = 0;
while($row = mysqli_fetch_assoc($res)){
$x++;
$isDebit = strtoupper($row['type']) === 'DEBIT';
?>
<tr>
<td></td>

<td class="<?= $isDebit?'text-danger':'text-success' ?> fw-bold">
  <?= $isDebit?'-':'+' ?><?= $row['amount'] ?>
</td>

<td><span class="badge bg-secondary"><?= $row['balance'] ?></span></td>

<td><?= htmlspecialchars($row['purpose']) ?></td>

<td>
  <span class="badge <?= $isDebit?'bg-danger':'bg-success' ?>">
    <?= strtoupper($row['type']) ?>
  </span>
</td>

<td><?= htmlspecialchars($row['userid']) ?></td>

<td data-order="<?= strtotime($row['date']) ?>">
  <?= date('d M Y h:i A', strtotime($row['date'])) ?>
</td>
</tr>
<?php } ?>

</tbody>
</table>
</div>

</div>
</div>
</div>
</div>

<?php include('../template/tngweb/footer.php'); ?>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>

<script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.bootstrap5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.print.min.js"></script>

<script src="https://cdn.datatables.net/responsive/2.5.0/js/dataTables.responsive.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.5.0/js/responsive.bootstrap5.min.js"></script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>

<script>
$(document).ready(function(){

  const table = $('#walletTable').DataTable({
    responsive:true,
    pageLength:10,
    lengthChange:false,
    order:[[6,'desc']],
    dom:
      "<'row mb-3'<'col-md-6'l><'col-md-6 text-end'B>>"+
      "<'row'<'col-12'tr>>"+
      "<'row mt-3'<'col-md-5'i><'col-md-7'p>>",
    buttons:[
      {extend:'excel', className:'btn btn-success btn-sm rounded-pill px-3'},
      {extend:'pdf', className:'btn btn-danger btn-sm rounded-pill px-3'},
      {extend:'print', className:'btn btn-primary btn-sm rounded-pill px-3'}
    ],
    columnDefs:[{orderable:false,targets:0}]
  });

  table.on('order.dt search.dt', function(){
    table.column(0,{search:'applied',order:'applied'})
         .nodes().each((cell,i)=>cell.innerHTML=i+1);
  }).draw();

});
</script>

<style>
.luxury-card{
  border-radius:20px;
  background:linear-gradient(145deg,#fff,#eef2ff);
}
.luxury-thead th{
  background:linear-gradient(135deg,#1e1e2f,#2f3350);
  color:#fff;
}
</style>
