(function() {
        'use strict';
        window.addEventListener('load', function() {
            var forms = document.getElementsByClassName('needs-validation');
            var validation = Array.prototype.filter.call(forms, function(form) {
                form.addEventListener('submit', function(event) {
                    if (form.checkValidity() === false) {
                        event.preventDefault();
                        event.stopPropagation();
                    }
                    form.classList.add('was-validated');
                }, false);
            });
        }, false);
    })();
    
    document.getElementById('downloadBtn')?.addEventListener('click', function() {
        const element = document.getElementById('resultContent');
        
        html2canvas(element, {
            scale: 2,
            useCORS: true,
            logging: false,
            backgroundColor: '#fef9e7'
        }).then(function(canvas) {
            const link = document.createElement('a');
            link.download = 'driving-licence-details.png';
            link.href = canvas.toDataURL('image/png');
            link.click();
        });
    });