<?php
@session_start();
include('../includes/session.php');   // Admin session check
include('../includes/config.php');
include('../template/tngweb/header.php');  // Admin header

$alert_script = '';

if(isset($_POST['submit'])) {
    $name = $_POST['name'];
    $email = $_POST['email'];
    $mobile = $_POST['mobile'];
    $message = $_POST['message'];

    $result = submitContactQuery($name, $email, $mobile, $message);

    if($result['success']) {
        $ticket_number = $result['ticket_number'];
        $alert_script = '
            Swal.fire({
                title: "Success! 🎉",
                html: "Your message has been sent successfully!<br><br><strong>Ticket Number:</strong> ' . $ticket_number . '<br><br>We have sent a confirmation to your email.",
                icon: "success",
                confirmButtonColor: "#4bb543"
            }).then(() => {
                document.getElementById("contactForm").reset();
            });
        ';
    } else {
        $alert_script = '
            Swal.fire({
                title: "Error!",
                text: "Failed to send message. Please try again. '.$result['error'].'",
                icon: "error",
                confirmButtonColor: "#dc3545"
            });
        ';
    }
}
?>

<div class="content-wrap">
    <div class="main">
        <div class="page-wrapper">
            <div class="page-content">
                <div class="mobile-menu-overlay"></div>
                <div class="main-container">
                    <div class="col-lg-12">
                        <div class="card p-3" style="margin-left: 10px; box-shadow: 1px 5px 5px 5px;">
                            <div class="stat-widget-two">
                                <div class="stat-content">
                                    <div class="stat-text">
                                        <div class="container-fluid">
                                            <div class="row justify-content-center">
                                                <div class="col-lg-6 col-md-8">
                                                    <div class="card">
                                                        <div class="card-body">
                                                            <h3 class="mb-3">Contact Us</h3>
                                                            <p>We'd love to hear from you. Send us a message!</p>

                                                            <form method="POST" action="" id="contactForm">
                                                                <div class="form-group mb-3">
                                                                    <label for="name">Full Name *</label>
                                                                    <input type="text" name="name" id="name" class="form-control" placeholder="Enter your full name" required>
                                                                </div>
                                                                
                                                                <div class="form-group mb-3">
                                                                    <label for="email">Email Address *</label>
                                                                    <input type="email" name="email" id="email" class="form-control" placeholder="Enter your email" required>
                                                                </div>
                                                                
                                                                <div class="form-group mb-3">
                                                                    <label for="mobile">Mobile Number *</label>
                                                                    <input type="text" name="mobile" id="mobile" class="form-control" placeholder="Enter your mobile number" maxlength="10" required>
                                                                </div>
                                                                
                                                                <div class="form-group mb-3">
                                                                    <label for="message">Message *</label>
                                                                    <textarea name="message" id="message" class="form-control" placeholder="Enter your message" required></textarea>
                                                                </div>
                                                                
                                                                <div class="text-end">
                                                                    <button type="submit" name="submit" class="btn btn-success">
                                                                        <i class="bx bx-send"></i> Send Message
                                                                    </button>
                                                                </div>
                                                            </form>
                                                            <div class="mt-3">
                                                                <a href="CheckStatus.php">Check existing ticket status</a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div> <!-- col -->
                                            </div> <!-- row -->
                                        </div> <!-- container -->
                                    </div>
                                </div>
                            </div>
                        </div>
                        <br><br>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include('../template/tngweb/footer.php'); ?>

<script src="../template/tngweb/assets/js/bootstrap.bundle.min.js"></script>
<script src="../template/tngweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/tngweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/tngweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<script src="../template/tngweb/assets/js/app.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    // Mobile input: numbers only
    document.getElementById('mobile').addEventListener('input', function() {
        this.value = this.value.replace(/[^0-9]/g, '');
    });

    // Form validation
    document.getElementById('contactForm').addEventListener('submit', function(e) {
        const name = document.getElementById('name').value.trim();
        const email = document.getElementById('email').value.trim();
        const mobile = document.getElementById('mobile').value.trim();
        const message = document.getElementById('message').value.trim();

        if(!name || !email || !mobile || !message) {
            e.preventDefault();
            Swal.fire({ title: "Required!", text: "Please fill all required fields", icon: "warning", confirmButtonColor: "#ffc107" });
            return;
        }

        if(mobile.length !== 10) {
            e.preventDefault();
            Swal.fire({ title: "Invalid Mobile!", text: "Please enter a valid 10-digit mobile number", icon: "warning", confirmButtonColor: "#ffc107" });
            return;
        }

        const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        if(!emailRegex.test(email)) {
            e.preventDefault();
            Swal.fire({ title: "Invalid Email!", text: "Please enter a valid email address", icon: "warning", confirmButtonColor: "#ffc107" });
            return;
        }
    });

    // Auto focus + show alert if any
    document.addEventListener('DOMContentLoaded', function() {
        document.getElementById('name').focus();
        <?php if(!empty($alert_script)) { echo $alert_script; } ?>
    });
</script>
