<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/tngweb/header.php');
checkGatewayStatus();
$mobileno = $udata['phone'];


function curl_get($url, $timeout = 0) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
    curl_setopt($ch, CURLOPT_TIMEOUT, $timeout);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $resp = curl_exec($ch);
    $err  = curl_error($ch);
    $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    return ['http_code' => $code, 'response' => $resp, 'error' => $err];
}


function wallet_txn_exists($conn, $banktxnid, $phone) {
    $sql = "SELECT COUNT(*) as cnt FROM wallet WHERE BANKTXNID = ? AND phone = ?";
    if ($stmt = mysqli_prepare($conn, $sql)) {
        mysqli_stmt_bind_param($stmt, 'ss', $banktxnid, $phone);
        mysqli_stmt_execute($stmt);
        mysqli_stmt_bind_result($stmt, $cnt);
        mysqli_stmt_fetch($stmt);
        mysqli_stmt_close($stmt);
        return ($cnt > 0);
    }
    return false;
}


if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['amount'])) {
    $amount = $_POST['amount'] ?? '';

    if (!$amount || !is_numeric($amount) || $amount <= XyZ_val('balance_add_minumum_amount')) {
        echo "<script>
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Please enter a valid amount greater than $amount',
                confirmButtonColor: '#4e54c8'
            });
        </script>";
    } else {
        $url = "https://".JkL_get('paymentapi','gateway_Url')."/qr_verification?amount=" . urlencode($amount) . "&apikey=" . urlencode(JkL_get('paymentapi','gateway_apikey'));
        $res = curl_get($url, 20);
        $data = json_decode($res['response'], true);

        if (isset($data['error'])) {
            echo "<script>
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: '" . addslashes($data['error']) . "',
                    confirmButtonColor: '#4e54c8'
                });
            </script>";
        } elseif (is_array($data) && isset($data['Message']) && $data['Message'] === 'Success') {
            $_SESSION['qr_data'] = $data;
            $_SESSION['qr_amount'] = $amount;
            $_SESSION['qr_generated_time'] = time();
            
            header("Location: wallet.php?show_qr=1");
            exit();
        } else {
            echo "<script>
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'Invalid response from payment gateway',
                    confirmButtonColor: '#4e54c8'
                });
            </script>";
        }
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['verify_payment'])) {
    $type = $_POST['type'] ?? '';
    $application_no = $_POST['application_no'] ?? '';
    $utr = $_POST['utr'] ?? '';

    unset($_SESSION['qr_data']);
    unset($_SESSION['qr_amount']);
    unset($_SESSION['qr_generated_time']);

    if (!$type || !$application_no || !$utr) {
        echo "<script>
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Please enter all required parameters including UTR number',
                confirmButtonColor: '#4e54c8'
            }).then(() => { window.location.href = 'wallet.php'; });
        </script>";
        exit();
    } else {
        $url = "https://".JkL_get('paymentapi','gateway_Url')."/bharatpaygateway_verification?type=" . urlencode($type) . "&application_no=" . urlencode($application_no) . "&utr=" . urlencode($utr) . "&apikey=" . urlencode(JkL_get('paymentapi','gateway_apikey'));

        $res = curl_get($url, 20);
        $data = json_decode($res['response'], true);

        if (isset($data['error'])) {
            echo "<script>
                Swal.fire({
                    icon: 'error',
                    title: 'Payment Failed',
                    text: '" . addslashes($data['error']) . "',
                    confirmButtonColor: '#4e54c8'
                }).then(() => { window.location.href = 'wallet.php'; });
            </script>";
            exit();
        } elseif (is_array($data) && isset($data['Message']) && $data['Message'] === 'Success' && isset($data['status']) && $data['status'] === 'SUCCESS') {
            $payerName = $data['payerName'] ?? 'QR Payment';
            $payerHandle = $data['payerHandle'] ?? 'QR';
            $txnAmount = $data['amount'];
            $utr = $data['utr'];
            $datetime = date("Y-m-d H:i:s");

            if (!wallet_txn_exists($tng_conn, $utr, $mobileno)) {
                $stmt = mysqli_prepare($tng_conn, "INSERT INTO wallet (phone, BANKTXNID, amount, RESPMSG, PAYMENTMODE, status, txn_date) VALUES (?, ?, ?, ?, ?, ?, ?)");
                mysqli_stmt_bind_param($stmt, 'ssissss', $mobileno, $utr, $txnAmount, $payerName, $payerHandle, $data['status'], $datetime);
                mysqli_stmt_execute($stmt);
                mysqli_stmt_close($stmt);

                $stmt = mysqli_prepare($tng_conn, "UPDATE users SET balance = balance + ? WHERE phone=?");
                mysqli_stmt_bind_param($stmt, 'is', $txnAmount, $mobileno);
                mysqli_stmt_execute($stmt);
                mysqli_stmt_close($stmt);

                
            }

            echo "<script>
                Swal.fire({
                    icon: 'success',
                    title: 'Payment Successful 🎉',
                    html: '<b>Amount:</b> ₹$txnAmount<br><b>Payer:</b> $payerName<br><b>Date:</b> $datetime',
                    confirmButtonColor: '#4e54c8'
                }).then(() => { window.location.href = 'wallet.php'; });
            </script>";
            exit();
        } else {
            echo "<script>
                Swal.fire({
                    icon: 'error',
                    title: 'Payment Failed ❌',
                    text: 'Transaction failed. Please check your UTR number or try again later.',
                    confirmButtonColor: '#4e54c8'
                }).then(() => { window.location.href = 'wallet.php'; });
            </script>";
            exit();
        }
    }
}


if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['check_paytm_status'])) {
    $application_no = $_POST['application_no'] ?? '';
    
    if (!$application_no) {
        echo json_encode(['status' => 'error', 'message' => 'Missing application number']);
        exit;
    }
    
    $url = "https://".JkL_get('paymentapi','gateway_Url')."/bharatpaygateway_verification?type=paytm&application_no=" . urlencode($application_no) . "&apikey=" . urlencode(JkL_get('paymentapi','gateway_apikey'));
    $res = curl_get($url, 20);
    $data = json_decode($res['response'], true);
    
    if (isset($data['error'])) {
        echo json_encode(['status' => 'pending', 'message' => $data['error']]);
        exit;
    }
    
    if (is_array($data) && isset($data['Message']) && $data['Message'] === 'Success' && isset($data['status']) && $data['status'] === 'SUCCESS') {
        $payerName = $data['payerName'] ?? 'QR Payment';
        $payerHandle = $data['payerHandle'] ?? 'QR';
        $txnAmount = $data['amount'];
        $utr = $data['utr'];
        $datetime = date("Y-m-d H:i:s");

        if (!wallet_txn_exists($tng_conn, $utr, $mobileno)) {
            $stmt = mysqli_prepare($tng_conn, "INSERT INTO wallet (phone, BANKTXNID, amount, RESPMSG, PAYMENTMODE, status, txn_date) VALUES (?, ?, ?, ?, ?, ?, ?)");
            mysqli_stmt_bind_param($stmt, 'ssissss', $mobileno, $utr, $txnAmount, $payerName, $payerHandle, $data['status'], $datetime);
            mysqli_stmt_execute($stmt);
            mysqli_stmt_close($stmt);

            $stmt = mysqli_prepare($tng_conn, "UPDATE users SET balance = balance + ? WHERE phone=?");
            mysqli_stmt_bind_param($stmt, 'is', $txnAmount, $mobileno);
            mysqli_stmt_execute($stmt);
            mysqli_stmt_close($stmt);

            
        }
        
    
        unset($_SESSION['qr_data']);
        unset($_SESSION['qr_amount']);
        unset($_SESSION['qr_generated_time']);
        
        echo json_encode([
            'status' => 'success', 
            'message' => 'Payment successful',
            'data' => [
                'amount' => $txnAmount,
                'payer' => $payerName,
                'date' => $datetime
            ]
        ]);
        exit;
    }
    
    echo json_encode(['status' => 'pending', 'message' => 'Waiting for payment...']);
    exit;
}


if (isset($_SESSION['qr_data']) && $_SESSION['qr_data']['type'] === 'paytm' && isset($_GET['show_qr'])) {
    $application_no = $_SESSION['qr_data']['application_no'];
    $url = "https://".JkL_get('paymentapi','gateway_Url')."/bharatpaygateway_verification?type=paytm&application_no=" . urlencode($application_no) . "&apikey=" . urlencode(JkL_get('paymentapi','gateway_apikey'));
    $res = curl_get($url, 20);
    $data = json_decode($res['response'], true);
    
    if (is_array($data) && isset($data['Message']) && $data['Message'] === 'Success' && isset($data['status']) && $data['status'] === 'SUCCESS') {
        $payerName = $data['payerName'] ?? 'QR Payment';
        $payerHandle = $data['payerHandle'] ?? 'QR';
        $txnAmount = $data['amount'];
        $utr = $data['utr'];
        $datetime = date("Y-m-d H:i:s");

        if (!wallet_txn_exists($tng_conn, $utr, $mobileno)) {
            $stmt = mysqli_prepare($tng_conn, "INSERT INTO wallet (phone, BANKTXNID, amount, RESPMSG, PAYMENTMODE, status, txn_date) VALUES (?, ?, ?, ?, ?, ?, ?)");
            mysqli_stmt_bind_param($stmt, 'ssissss', $mobileno, $utr, $txnAmount, $payerName, $payerHandle, $data['status'], $datetime);
            mysqli_stmt_execute($stmt);
            mysqli_stmt_close($stmt);

            $stmt = mysqli_prepare($tng_conn, "UPDATE users SET balance = balance + ? WHERE phone=?");
            mysqli_stmt_bind_param($stmt, 'is', $txnAmount, $mobileno);
            mysqli_stmt_execute($stmt);
            mysqli_stmt_close($stmt);

            
        }
     
        unset($_SESSION['qr_data']);
        unset($_SESSION['qr_amount']);
        unset($_SESSION['qr_generated_time']);
     
        echo "<script>
            Swal.fire({
                icon: 'success',
                title: 'Payment Successful 🎉',
                html: '<b>Amount:</b> ₹$txnAmount<br><b>Payer:</b> $payerName<br><b>Date:</b> $datetime',
                confirmButtonColor: '#4e54c8'
            }).then(() => { window.location.href = 'wallet.php'; });
        </script>";
        exit;
    }
}
?>
<!--start page wrapper -->
<div class="page-wrapper">
  <div class="page-content">
    <div class="card radius-15 shadow-lg border-0">
      <div class="card-body">
        <!-- Back Button -->
        <div class="d-flex align-items-center justify-content-between mb-3">
          <a href="javascript:void(0);" onclick="window.history.back();" class="btn btn-outline-primary rounded-pill px-4 py-2 fw-semibold">
            <i class="bi bi-arrow-left-circle me-2"></i> Go Back
          </a>
          <h5 class="mb-0 fw-bold text-primary">💰 Wallet Added</h5>
        </div>
        <form method="POST" action="" style="max-width:500px;margin:auto;">
  <div style="display:flex;align-items:center;gap:10px;">
    
    <!-- Input Box -->
    <div style="position:relative;flex:1;">
      <span style="position:absolute;left:10px;top:50%;transform:translateY(-50%);color:#555;">
        <i class="fas fa-indian-rupee-sign"></i>
      </span>
      <input type="number" id="amount" name="amount" required step="1"
             placeholder="Enter amount (₹ <?php echo XyZ_val('balance_add_minumum_amount'); ?>)"
             style="width:100%;padding:10px 10px 10px 30px;border:1px solid #ccc;
                    border-radius:8px;font-size:15px;outline:none;
                    transition:0.3s;">
    </div>

    <!-- Button -->
    <button type="submit"
            style="background:linear-gradient(135deg,#0078ff,#00d4ff);
                   border:none;color:white;padding:10px 18px;
                   border-radius:8px;font-size:15px;
                   display:flex;align-items:center;gap:8px;
                   cursor:pointer;transition:0.3s;">
      <i class="fas fa-qrcode"></i> Generate
    </button>

  </div>
</form>


         <h6 class="mb-0 text-uppercase">Payment List</h6>
				<hr/>
			 <div class="table-responsive">
          <table id="walletTable" class="table table-hover table-striped align-middle text-center">
            <thead class="table-dark">
              <tr>
                            <th>#</th>
                            <th>UTR</th>
                            <th>Amount</th>
                            <th>Payer</th>
                            <th>Method</th>
                            <th>Status</th>
                            <th>Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        if ($udata['type'] == 'admin') {
                            $res = mysqli_query($tng_conn, "SELECT * FROM wallet ORDER BY txn_date DESC");
                        } else {
                            $phone = mysqli_real_escape_string($tng_conn, $udata['phone']);
                            $res = mysqli_query($tng_conn, "SELECT * FROM wallet WHERE phone='$phone' ORDER BY txn_date DESC");
                        }

                        $i = 1;
                        while ($row = mysqli_fetch_assoc($res)) {
                            echo "<tr>
                                <td>{$i}</td>
                                <td>".htmlspecialchars($row['BANKTXNID'])."</td>
                                <td>₹".htmlspecialchars($row['amount'])."</td>
                                <td>".htmlspecialchars($row['RESPMSG'])."</td>
                                <td>".htmlspecialchars($row['PAYMENTMODE'])."</td>
                                <td><span class='badge bg-".($row['status']=='success'?'success':'danger')."'>".htmlspecialchars($row['status'])."</span></td>
                                <td>".htmlspecialchars($row['txn_date'])."</td>
                            </tr>";
                            $i++;
                        }
                        ?>
					  </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>

<?php
if (isset($_GET['show_qr']) && isset($_SESSION['qr_data']) && is_array($_SESSION['qr_data']) && !isset($_POST['verify_payment'])) {
    $data = $_SESSION['qr_data'];
    $amount = $_SESSION['qr_amount'] ?? 0;
    
    // Compact and professional QR display
    $html = '
    <div style="text-align:center; padding:10px;">
        <div style="background:#f8f9fa; border-radius:10px; padding:15px; margin-bottom:15px;">
            <h5 style="color:#2c3e50; margin-bottom:10px; font-size:16px;">💳 Payment Details</h5>
            <div style="display:flex; justify-content:center; gap:15px; margin-bottom:12px; flex-wrap:wrap;">
                <div style="background:white; padding:8px 12px; border-radius:6px; box-shadow:0 1px 3px rgba(0,0,0,0.1); font-size:13px;">
                    <strong>🏢</strong> ' . ($data['companyName'] ?? 'N/A') . '
                </div>
                <div style="background:white; padding:8px 12px; border-radius:6px; box-shadow:0 1px 3px rgba(0,0,0,0.1); font-size:13px;">
                    <strong>₹</strong> ' . ($data['amount'] ?? $amount) . '
                </div>
            </div>
        </div>
        
        <div style="background:white; padding:15px; border-radius:10px; display:inline-block; box-shadow:0 2px 8px rgba(0,0,0,0.1); margin-bottom:15px;">
            <img src="' . $data['qr'] . '" style="width:160px;height:160px; border:1px solid #e9ecef; border-radius:6px;">
        </div>
        
        <div id="txnStatus" style="margin-top:12px; padding:10px; background:#e8f4fd; border-radius:6px; border-left:3px solid #2196F3; color:#2c3e50; font-size:13px; font-weight:500;">
            <i class="fas fa-sync-alt fa-spin" style="margin-right:5px;"></i> Waiting for payment...
        </div>
    </div>';
    
    // Compact UTR input for BharatPay
    if ($data['type'] === "bharatpay") {
        $html .= '
        <div style="background:#fff3cd; border:1px solid #ffc107; border-radius:8px; padding:15px; margin-top:12px;">
            <h6 style="color:#856404; margin-bottom:10px; display:flex; align-items:center; gap:6px; font-size:14px;">
                <i class="fas fa-exclamation-triangle"></i> UTR Number Required
            </h6>
            <p style="color:#856404; margin-bottom:10px; font-size:12px; line-height:1.4;">
                After payment, enter the <strong>UTR number</strong> from your bank transaction.
            </p>
            <div style="position:relative;">
                <span style="position:absolute; left:12px; top:50%; transform:translateY(-50%); color:#495057; font-size:14px;">
                    <i class="fas fa-receipt"></i>
                </span>
                <input id="utrInput" 
                       class="swal2-input" 
                       placeholder="Enter UTR Number" 
                       style="width:100%; padding:10px 10px 10px 35px; border:1.5px solid #4e54c8; border-radius:6px; font-size:14px; background:#f8f9fa; transition:all 0.2s;"
                       onfocus="this.style.borderColor=\'#007bff\'; this.style.boxShadow=\'0 0 0 2px rgba(78, 84, 200, 0.1)\'"
                       onblur="this.style.borderColor=\'#4e54c8\'; this.style.boxShadow=\'none\'">
            </div>
        </div>';
    }
    
    echo '<script>
    Swal.fire({
        title: "' . ($data['type'] === "bharatpay" ? "Scan QR & Enter UTR" : "Scan QR to Pay") . '",
        html: `' . $html . '`,
        showConfirmButton: ' . ($data['type'] === "bharatpay" ? 'true' : 'false') . ',
        confirmButtonText: "✅ Verify Payment",
        confirmButtonColor: "#28a745",
        showCancelButton: true,
        cancelButtonText: "⬅ Back",
        cancelButtonColor: "#6c757d",
        allowOutsideClick: false,
        width: "420px",
        customClass: {
            popup: "qr-popup",
            header: "qr-header",
            content: "qr-content"
        },
        didOpen: () => {
            if("' . $data['type'] . '" === "paytm"){
                checkPaytmStatus("' . $data['application_no'] . '");
            } else if("' . $data['type'] . '" === "bharatpay") {
                setTimeout(() => {
                    const utrInput = document.getElementById("utrInput");
                    if(utrInput) utrInput.focus();
                }, 300);
            }
        }
    }).then(result => {
        if(result.dismiss === Swal.DismissReason.cancel){
            window.location.href = "wallet.php";
        }
        else if(result.isConfirmed && "' . $data['type'] . '" === "bharatpay"){
            let utr = document.getElementById("utrInput").value.trim();
            if(!utr) {
                Swal.showValidationMessage("Please enter UTR number");
                return false;
            }
            
            if(utr.length < 8) {
                Swal.showValidationMessage("UTR number seems too short");
                return false;
            }
            
            const form = document.createElement("form");
            form.method = "POST";
            form.action = "";
            
            const typeInput = document.createElement("input");
            typeInput.type = "hidden";
            typeInput.name = "type";
            typeInput.value = "bharatpay";
            form.appendChild(typeInput);
            
            const appInput = document.createElement("input");
            appInput.type = "hidden";
            appInput.name = "application_no";
            appInput.value = "' . $data['application_no'] . '";
            form.appendChild(appInput);
            
            const utrInput = document.createElement("input");
            utrInput.type = "hidden";
            utrInput.name = "utr";
            utrInput.value = utr;
            form.appendChild(utrInput);
            
            const verifyInput = document.createElement("input");
            verifyInput.type = "hidden";
            verifyInput.name = "verify_payment";
            verifyInput.value = "1";
            form.appendChild(verifyInput);
            
            document.body.appendChild(form);
            form.submit();
        }
    });
    </script>';

}
?>

<!-- Compact and professional styling -->
<style>
.swal2-popup.qr-popup {
    border-radius: 12px;
    box-shadow: 0 8px 25px rgba(0,0,0,0.15);
}

.swal2-title.qr-header {
    color: #2c3e50;
    font-weight: 600;
    padding: 15px 20px 10px;
    font-size: 18px;
}

.swal2-content.qr-content {
    padding: 0 15px 15px;
    font-size: 14px;
}

/* Animation for status updates */
@keyframes pulse {
    0% { opacity: 1; }
    50% { opacity: 0.7; }
    100% { opacity: 1; }
}

.pulse {
    animation: pulse 2s infinite;
}

/* Compact form styling */
form[style*="max-width:500px"] {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    padding: 20px;
    border-radius: 12px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    margin-bottom: 25px !important;
}

form[style*="max-width:500px"] input {
    border: 1px solid transparent !important;
    font-size: 14px !important;
}

form[style*="max-width:500px"] input:focus {
    border-color: #fff !important;
    box-shadow: 0 0 0 2px rgba(255,255,255,0.2) !important;
}

form[style*="max-width:500px"] button {
    background: linear-gradient(135deg, #ff6b6b, #ee5a24) !important;
    border: none;
    font-weight: 600;
    font-size: 14px !important;
    padding: 10px 15px !important;
}
</style>

<script>
function checkPaytmStatus(application_no) {
    const statusDiv = document.getElementById("txnStatus");
    let checkCount = 0;
    const maxChecks = 60; 
    
    statusDiv.classList.add('pulse');
    
    const intervalId = setInterval(async () => {
        try {
            checkCount++;
            statusDiv.innerHTML = `<i class="fas fa-sync-alt fa-spin"></i> Checking... (${checkCount}/${maxChecks})`;
            
            const formData = new FormData();
            formData.append('check_paytm_status', '1');
            formData.append('application_no', application_no);
            
            const response = await fetch('', {
                method: 'POST',
                body: formData
            });
            
            const data = await response.json();
            
            if (data.status === 'success') {
                clearInterval(intervalId);
                statusDiv.classList.remove('pulse');
                statusDiv.innerHTML = `<i class="fas fa-check-circle" style="color:#28a745;"></i> Payment Successful!`;
                
                setTimeout(() => {
                    Swal.close();
                    Swal.fire({
                        icon: 'success',
                        title: 'Payment Successful 🎉',
                        html: `<div style="text-align:left; padding:8px; font-size:14px;">
                                 <p><b>Amount:</b> ₹${data.data.amount}</p>
                                 <p><b>Payer:</b> ${data.data.payer}</p>
                                 <p><b>Date:</b> ${data.data.date}</p>
                               </div>`,
                        confirmButtonColor: '#4e54c8',
                        showCancelButton: false
                    }).then(() => { 
                        window.location.href = 'wallet.php'; 
                    });
                }, 1000);
            } else if (data.status === 'error') {
                statusDiv.innerHTML = `<i class="fas fa-exclamation-triangle" style="color:#dc3545;"></i> ${data.message}`;
                
                if (data.message.includes('not successful') || data.message.includes('failed')) {
                    clearInterval(intervalId);
                    statusDiv.classList.remove('pulse');
                    statusDiv.innerHTML = `<i class="fas fa-times-circle" style="color:#dc3545;"></i> Payment failed`;
                }
            }
            
            if (checkCount >= maxChecks) {
                clearInterval(intervalId);
                statusDiv.classList.remove('pulse');
                statusDiv.innerHTML = `<i class="fas fa-clock" style="color:#6c757d;"></i> Timeout - Contact support`;
            }
        } catch (error) {
            console.error('Error checking payment status:', error);
            statusDiv.innerHTML = `<i class="fas fa-exclamation-circle" style="color:#ffc107;"></i> Error - Retrying...`;
        }
    }, 5000);
}

<?php if (isset($_SESSION['qr_data']) && $_SESSION['qr_data']['type'] === 'paytm' && isset($_GET['show_qr'])): ?>
setTimeout(function() {
    window.location.reload();
}, 5000);
<?php endif; ?>
</script>

</body>
<!--end page wrapper -->

          
<!--end page wrapper -->

<?php include('../template/tngweb/footer.php'); ?>

<!-- ✅ DataTables CDN & Scripts -->
<script src="../template/tngweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/tngweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/tngweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<script src="../template/tngweb/assets/js/app.js"></script>


<script>
  $(document).ready(function() {
    $('#walletTable').DataTable({
      lengthChange: false,
      pageLength: 10,
      order: [[0, "desc"]],
      buttons: ['copy', 'excel', 'pdf', 'print'],
      dom: '<"d-flex justify-content-between align-items-center mb-3"Bf>rt<"d-flex justify-content-between align-items-center"ip>'
    });
  });
</script>

<style>
  /* 🌟 Stylish Table */
  .table thead th {
    vertical-align: middle;
    font-weight: 600;
    letter-spacing: 0.3px;
  }

  .table tbody tr:hover {
    background: #f5f8ff;
    transition: 0.2s ease;
  }

  .card {
    background: #fff;
    border-radius: 15px;
  }

  .btn-outline-primary {
    border-color: #0055ff;
    color: #0055ff;
  }

  .btn-outline-primary:hover {
    background-color: #0055ff;
    color: #fff;
  }

  .dataTables_wrapper .dataTables_filter input {
    border-radius: 8px;
    padding: 5px 10px;
  }

  .dataTables_wrapper .dataTables_paginate .paginate_button {
    border-radius: 5px;
  }

  .dataTables_wrapper .dt-buttons .btn {
    border-radius: 20px !important;
    font-size: 0.85rem;
    margin-right: 6px;
  }

  .badge {
    font-size: 0.8rem;
    padding: 6px 10px;
  }
</style>