<?php
@session_start();
include('includes/config.php');

$status_result = null;
$ticket_number = '';

if(isset($_POST['check_status']) || isset($_GET['ticket'])) {
    $ticket_number = isset($_GET['ticket']) ? $_GET['ticket'] : $_POST['ticket_number'];
    $status_result = getTicketStatus($ticket_number);
}

?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" href="./template/tngweb/assets/images/favicon-32x32.png" type="image/png" />
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="./template/tngweb/assets/css/CheckStatus.css" rel="stylesheet">
    <link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>
    <title><?php echo XyZ_val('brand'); ?> | Check Ticket Status</title>
    
</head>

<body>
    <nav class="navbar">
        <div class="nav-container">
            <a href="index.php" class="logo">
                <img src="<?php echo XyZ_val('logo'); ?>" alt="Logo">
                <?php echo XyZ_val('brand'); ?>
            </a>
            
            <ul class="nav-links">
                <li><a href="index.php">Home</a></li>
                <li><a href="contact.php">Contact</a></li>
                <li><a href="check_status.php" class="active">Check Status</a></li>
            </ul>
        </div>
    </nav>

    <div class="status-container">
        <div class="status-card">
            <div class="status-header">
                <i class='bx bx-search-alt' style="font-size: 3rem; margin-bottom: 1rem; display: block;"></i>
                <h1>Check Ticket Status</h1>
                <p>Enter your ticket number to check the response status</p>
            </div>
            
            <div class="status-body">
                <form method="POST" action="">
                    <div class="form-group">
                        <input type="text" name="ticket_number" class="form-control" 
                               placeholder="Enter your ticket number (e.g., TNG202312011234)" 
                               value="<?php echo htmlspecialchars($ticket_number); ?>" required>
                    </div>
                    
                    <button type="submit" name="check_status" class="submit-btn">
                        <i class='bx bx-search'></i> Check Status
                    </button>
                </form>
                
                <?php if(isset($_POST['check_status']) || isset($_GET['ticket'])): ?>
                    <?php if($status_result): ?>
                        <div class="ticket-details">
                            <h3 style="margin-bottom: 1rem; color: var(--primary);">Ticket Details</h3>
                            
                            <div class="detail-row">
                                <strong>Ticket Number:</strong> <?php echo $status_result['ticket_number']; ?>
                            </div>
                            
                            <div class="detail-row">
                                <strong>Status:</strong> 
                                <span class="status-badge status-<?php echo $status_result['status']; ?>">
                                    <?php echo ucfirst($status_result['status']); ?>
                                </span>
                            </div>
                            
                            <div class="detail-row">
                                <strong>Submitted On:</strong> <?php echo date('M j, Y g:i A', strtotime($status_result['created_at'])); ?>
                            </div>
                            
                            <div class="detail-row">
                                <strong>Name:</strong> <?php echo htmlspecialchars($status_result['name']); ?>
                            </div>
                            
                            <div class="detail-row">
                                <strong>Email:</strong> <?php echo htmlspecialchars($status_result['email']); ?>
                            </div>
                            
                            <div class="detail-row">
                                <strong>Message:</strong><br>
                                <?php echo nl2br(htmlspecialchars($status_result['message'])); ?>
                            </div>
                        </div>
                        
                        <?php if($status_result['reply_message']): ?>
                            <div class="reply-section">
                                <h4 style="color: var(--primary); margin-bottom: 1rem;">
                                    <i class='bx bx-message-check'></i> Admin Response
                                </h4>
                                <p><?php echo nl2br(htmlspecialchars($status_result['reply_message'])); ?></p>
                                <div style="margin-top: 1rem; color: #666;">
                                    <small>
                                        Replied by: <?php echo $status_result['replied_by']; ?> 
                                        on <?php echo date('M j, Y g:i A', strtotime($status_result['replied_at'])); ?>
                                    </small>
                                </div>
                            </div>
                        <?php else: ?>
                            <div class="no-reply">
                                <i class='bx bx-time'></i>
                                <p>Your query is being processed. Our team will respond soon.</p>
                            </div>
                        <?php endif; ?>
                        
                    <?php else: ?>
                        <div class="no-reply" style="margin-top: 1.5rem;">
                            <i class='bx bx-error'></i>
                            <p>No ticket found with the provided ticket number. Please check and try again.</p>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <footer class="footer">
        <p>&copy; <?php echo date("Y"); ?> <?php echo XyZ_val('brand'); ?>. All rights reserved.</p>
    </footer>
</body>
</html>